#in order to start this script, type "source vdw.tcl" in the vmd console or, otherwise, put "source vdw.tcl" in the .vmdrc file to run the script automatically at the vmd startup#
labels off

package require pbctools 

color Display BackgroundTop gray
color Display BackgroundBot white
display backgroundgradient on

set fp [open "./ProteinEigenschaften.csv" r]
    set file_data [read $fp]
    close $fp

set data [split $file_data "\n"]
#    foreach line $data {
#        echo [lindex $line 1]    
#    }
#echo [lindex $data 0 2]


#Loading the molecule
#mol load lammpstrj test.lammpstrj

#list with the radii sort by order in .bngl & .geo files
#old list {{0} {16.81} {18.66} {22.04} {14.66} {15.04} {12.6} {14.89} {14.5} {11.7} {12.6} {18.22} {10} {15.81} {20.57} {11.7} {11.19} {11.19} {11.45} {10.32} {15.74} {9.65}}
#set radlist {{0} {22.03} {24.46} {28.88} {19.21} {19.70} {16.51} {19.51} {19.00} {15.33} {16.51} {23.88} {13.10} {20.71} {26.95} {15.33} {14.66} {14.66} {15.00} {13.53} {20.63} {12.65} {18.58}}

set molnum [molinfo num]

for {set molid 0} {$molnum > $molid} {incr molid} {

#set the molecule style to VDW and coloring method to SegName
mol modstyle 0 $molid VDW 1 50
mol modcolor 0 $molid SegName
mol smoothrep $molid 0 5

#get the max value from a list
proc max list {
    set res [lindex $list 0]
    foreach element [lrange $list 1 end] {
       if {$element > $res} {set res $element}
    }
    set res
 }

#select all atoms
set allatom [atomselect $molid all]
#select all names from the atoms
set allatomname [$allatom get name]
#set the max-value
set maxlst [max $allatomname]

#set the radii, segname category and colors in order:(blue = 0, red = 1, gray, orange, yellow, tan, silver, green, white, pink, cyan, purple, lime, mauve, ochre, iceblue, black)
set numofmols [expr {[llength $data]-1}]
#echo $numofmols

set x 1
for {set i 1} {$numofmols > $i} {incr i} {
    if {[lindex $data $i 9] == "1"} {
        set blub [atomselect $molid "name $x"]
        $blub set segname [lindex $data $i 1]
        incr x
        #echo i:$i x:$x [$blub get name]
        if {[$blub num] != 0} {
             $blub set radius [lindex $data $i 2]
             color Segname [lindex $data $i 1] $i
           }
    }
}

for {set i 1} {$numofmols > $i} {incr i} {
    color change rgb $i [lindex $data $i 4] [lindex $data $i 5] [lindex $data $i 6]


}
}
labels legend

## draw a box, centered on the origin
#pbc box -center origin

#proc label_atom {selection_string label_string} {
#    set sel [atomselect top $selection_string]
#    if {[$sel num] != 1} {
#        error "label_atom: '$selection_string' must select 1 atom"
#    }
#    # get the coordinates of the atom
#    lassign [$sel get {x y z}] coord
#    # and draw the text
#    draw text $coord $label_string
#}
